package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.Trackable;
import it.eng.eremita.graphql.types.Validable;

@Entity
@Table(name="EREMITA_MONITORAGGIO_SPECIE")
@SequenceGenerator(name="SEQ_MONITORAGGIO_SPECIE", sequenceName="SEQ_MONITORAGGIO_SPECIE", initialValue=1, allocationSize=1)
public class MonitoraggioSpecie implements Serializable,Identifiable<Long>,Trackable<Utente,Long>,Validable {

	

	Long id;
	String validato;
	Specie specie;
	String idScheda;
	String rilevatore;
	SitoNatura2000 sito;
	BigDecimal coordinataX;
	BigDecimal coordinataY;
	String provincia;
	String comune;
	String localita;
	Date timestampInizioRilievo;
	Date timestampFineRilievo;
	String transetto;
	BigDecimal lunghezzaTransetto;
	BigDecimal numeroPunti;
	CondizioniMeteo meteoInizio;
	CondizioniMeteo meteoFine;
	BigDecimal temperaturaAria;
	String vento;
	BigDecimal umiditaRelativa;
	TipologiaMonitoraggio tipologiaMonitoraggio;
	String note;
	String ente;
	String minacce;
	
	//dati specie acquatiche
	BigDecimal profonditaMinAcqua;
	BigDecimal profonditaMaxAcqua;
	Limpidezza limpidezza;
	BigDecimal visibilitaAcqua;
	BigDecimal temperaturaAcquaInizioTransetto;
	BigDecimal temperaturaAcquaFineTransetto;
	BigDecimal pH;
	BigDecimal conducibilita;
	BigDecimal durezza;
	
	Utente utenteCreazione;
	Utente utenteModifica;
	Date dataCreazione;
	Date dataModifica;
	
	//collezioni
	List<Segnalazione> segnalaziones = new ArrayList<Segnalazione>();
	List<SegnalazioneAltreSpecie> segnalazioneAltreSpecies = new ArrayList<SegnalazioneAltreSpecie>();
	List<Documento> documenti = new ArrayList<Documento>();
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_MONITORAGGIO_SPECIE")
	@Column(name="ID")
	@GraphQLQuery(name="id",description="Id oggetto, univoco.")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	
	@ManyToOne
	@JoinColumn(name="ID_SPECIE")
	@GraphQLQuery(name="specie",description="La specie del monitoraggio, tra quelle presenti in {specieProgettos}")
	public Specie getSpecie() {
		return specie;
	}

	public void setSpecie(Specie specie) {
		this.specie = specie;
	}
	
	
	@Column(name="ID_SCHEDA")
	@GraphQLQuery(name="idScheda")
	public String getIdScheda() {
		return idScheda;
	}

	public void setIdScheda(String idScheda) {
		this.idScheda = idScheda;
	}
	
	
	@Column(name="VALIDATO")
	public String getValidatoString() {
		return validato;
	}

	public void setValidatoString(String validato) {
		this.validato = validato;
	}
	
	@Transient
	@GraphQLQuery(name="validato")
	public Boolean getValidatoBoolean() {
		return (validato==null? null:(validato.equals("true")?true:false));
	}

	public void setValidatoBoolean(Boolean v) {
		if (v==null) validato = null;
		else if (v) validato = "true";
		else validato = "false";
	}

	@Column(name="RILEVATORI")
	@GraphQLQuery(name="rilevatori")
	public String getRilevatore() {
		return rilevatore;
	}

	public void setRilevatore(String rilevatore) {
		this.rilevatore = rilevatore;
	}

	@ManyToOne
	@JoinColumn(name="ID_SITO")
	@GraphQLQuery(name="sitoNatura2000",description="La lista dei valori possibili si ottiene con {sitoNatura2000s} e {sitoNatura2000SmartFilter}")
	public SitoNatura2000 getSito() {
		return sito;
	}

	public void setSito(SitoNatura2000 sito) {
		this.sito = sito;
	}

	@Column(name="PROVINCIA")
	@GraphQLQuery(name="provincia")
	public String getProvincia() {
		return provincia;
	}

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	@Column(name="COMUNE")
	@GraphQLQuery(name="comune")
	public String getComune() {
		return comune;
	}

	public void setComune(String comune) {
		this.comune = comune;
	}

	@Column(name="LOCALITA")
	@GraphQLQuery(name="localita")
	public String getLocalita() {
		return localita;
	}

	public void setLocalita(String localita) {
		this.localita = localita;
	}

	@Column(name="TS_INIZIO_RILIEVO")
	@Temporal(TemporalType.TIMESTAMP)
	@GraphQLQuery(name="inizioRilievo")
	public Date getTimestampInizioRilievo() {
		return timestampInizioRilievo;
	}

	public void setTimestampInizioRilievo(Date timestampInizioRilievo) {
		this.timestampInizioRilievo = timestampInizioRilievo;
	}

	@Column(name="TS_FINE_RILIEVO")
	@Temporal(TemporalType.TIMESTAMP)
	@GraphQLQuery(name="fineRilievo")
	public Date getTimestampFineRilievo() {
		return timestampFineRilievo;
	}

	public void setTimestampFineRilievo(Date timestampFineRilievo) {
		this.timestampFineRilievo = timestampFineRilievo;
	}

	@Column(name="TRANSETTO")
	@GraphQLQuery(name="transetto")
	public String getTransetto() {
		return transetto;
	}

	public void setTransetto(String transetto) {
		this.transetto = transetto;
	}

	@Column(name="LUNGHEZZA_TRANSETTO")
	@GraphQLQuery(name="lunghezzaTransetto")
	public BigDecimal getLunghezzaTransetto() {
		return lunghezzaTransetto;
	}
	
	public void setLunghezzaTransetto(BigDecimal lunghezzaTransetto) {
		this.lunghezzaTransetto = lunghezzaTransetto;
	}

	@Column(name="NUMERO_PUNTI")
	@GraphQLQuery(name="numeroPunti")
	public BigDecimal getNumeroPunti() {
		return numeroPunti;
	}

	public void setNumeroPunti(BigDecimal numeroPunti) {
		this.numeroPunti = numeroPunti;
	}

	@ManyToOne
	@JoinColumn(name="ID_METEO_INIZIO")
	@GraphQLQuery(name="meteoInizio",description="Menu, la lista dei valori possibili si ottiene con {condizioniMeteos}")
	public CondizioniMeteo getMeteoInizio() {
		return meteoInizio;
	}

	public void setMeteoInizio(CondizioniMeteo meteoInizio) {
		this.meteoInizio = meteoInizio;
	}

	@ManyToOne
	@JoinColumn(name="ID_METEO_FINE")
	@GraphQLQuery(name="meteoFine",description="Menu, la lista dei valori possibili si ottiene con {condizioniMeteos}")
	public CondizioniMeteo getMeteoFine() {
		return meteoFine;
	}

	public void setMeteoFine(CondizioniMeteo meteoFine) {
		this.meteoFine = meteoFine;
	}
	
	@Column(name="COORDINATA_X")
	@GraphQLQuery(name="coordinataX")
	public BigDecimal getCoordinataX() {
		return coordinataX;
	}
	public void setCoordinataX(BigDecimal coordinataX) {
		this.coordinataX = coordinataX;
	}
	
	@Column(name="COORDINATA_Y")
	@GraphQLQuery(name="coordinataY")
	public BigDecimal getCoordinataY() {
		return coordinataY;
	}
	public void setCoordinataY(BigDecimal coordinataY) {
		this.coordinataY = coordinataY;
	}

	@Column(name="TEMPERATURA_ARIA")
	@GraphQLQuery(name="temperaturaAria")
	public BigDecimal getTemperaturaAria() {
		return temperaturaAria;
	}

	public void setTemperaturaAria(BigDecimal temperaturaAria) {
		this.temperaturaAria = temperaturaAria;
	}

	@Column(name="VENTO")
	@GraphQLQuery(name="vento")
	public String getVento() {
		return vento;
	}

	public void setVento(String vento) {
		this.vento = vento;
	}

	@Column(name="UR")
	@GraphQLQuery(name="umiditaRelativa")
	public BigDecimal getUmiditaRelativa() {
		return umiditaRelativa;
	}

	public void setUmiditaRelativa(BigDecimal umiditaRelativa) {
		this.umiditaRelativa = umiditaRelativa;
	}

	@ManyToOne
	@JoinColumn(name="ID_TIPOLOGIA_MONITORAGGIO")
	@GraphQLQuery(name="tipologiaMonitoraggio",description="Menu, la lista dei valori possibili si ottiene con {tipologiaMonitoraggios}")
	public TipologiaMonitoraggio getTipologiaMonitoraggio() {
		return tipologiaMonitoraggio;
	}

	public void setTipologiaMonitoraggio(TipologiaMonitoraggio tipologiaMonitoraggio) {
		this.tipologiaMonitoraggio = tipologiaMonitoraggio;
	}
	
	@Column(name="NOTE")
	@GraphQLQuery(name="note")
	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	@Column(name="PROFONDITA_MIN_ACQUA")
	@GraphQLQuery(name="profonditaMinAcqua",description="Campo solo per specie acquatiche.")
	public BigDecimal getProfonditaMinAcqua() {
		return profonditaMinAcqua;
	}

	public void setProfonditaMinAcqua(BigDecimal profonditaMinAcqua) {
		this.profonditaMinAcqua = profonditaMinAcqua;
	}

	@Column(name="PROFONDITA_MAX_ACQUA")
	@GraphQLQuery(name="profonditaMaxAcqua",description="Campo solo per specie acquatiche.")
	public BigDecimal getProfonditaMaxAcqua() {
		return profonditaMaxAcqua;
	}

	public void setProfonditaMaxAcqua(BigDecimal profonditaMaxAcqua) {
		this.profonditaMaxAcqua = profonditaMaxAcqua;
	}

	@ManyToOne
	@JoinColumn(name="ID_LIMPIDEZZA")
	@GraphQLQuery(name="limpidezza",description="Campo solo per specie acquatiche, menu con lista {limpidezzas}")
	public Limpidezza getLimpidezza() {
		return limpidezza;
	}

	public void setLimpidezza(Limpidezza limpidezza) {
		this.limpidezza = limpidezza;
	}

	@Column(name="VISIBILITA_ACQUA")
	@GraphQLQuery(name="visibilitaAcqua",description="Campo solo per specie acquatiche.")
	public BigDecimal getVisibilitaAcqua() {
		return visibilitaAcqua;
	}

	public void setVisibilitaAcqua(BigDecimal visibilitaAcqua) {
		this.visibilitaAcqua = visibilitaAcqua;
	}

	@Column(name="TEMP_ACQUA_INIZIO_TRANSETTO")
	@GraphQLQuery(name="temperaturaAcquaInizioTransetto",description="Campo solo per specie acquatiche.")
	public BigDecimal getTemperaturaAcquaInizioTransetto() {
		return temperaturaAcquaInizioTransetto;
	}

	public void setTemperaturaAcquaInizioTransetto(BigDecimal temperaturaAcquaInizioTransetto) {
		this.temperaturaAcquaInizioTransetto = temperaturaAcquaInizioTransetto;
	}

	@Column(name="TEMP_ACQUA_FINE_TRANSETTO")
	@GraphQLQuery(name="temperaturaAcquaFineTransetto",description="Campo solo per specie acquatiche.")
	public BigDecimal getTemperaturaAcquaFineTransetto() {
		return temperaturaAcquaFineTransetto;
	}

	public void setTemperaturaAcquaFineTransetto(BigDecimal temperaturaAcquaFineTransetto) {
		this.temperaturaAcquaFineTransetto = temperaturaAcquaFineTransetto;
	}

	@Column(name="PH")
	@GraphQLQuery(name="pH",description="Campo solo per specie acquatiche.")
	public BigDecimal getpH() {
		return pH;
	}

	public void setpH(BigDecimal pH) {
		this.pH = pH;
	}

	@Column(name="CONDUCIBILITA")
	@GraphQLQuery(name="conducibilita",description="Campo solo per specie acquatiche.")
	public BigDecimal getConducibilita() {
		return conducibilita;
	}

	public void setConducibilita(BigDecimal conducibilita) {
		this.conducibilita = conducibilita;
	}

	@Column(name="DUREZZA")
	@GraphQLQuery(name="durezza",description="Campo solo per specie acquatiche.")
	public BigDecimal getDurezza() {
		return durezza;
	}

	public void setDurezza(BigDecimal durezza) {
		this.durezza = durezza;
	}
	
	@Column(name="ENTE")
	@GraphQLQuery(name="ente")
	public String getEnte() {
		return ente;
	}

	public void setEnte(String ente) {
		this.ente = ente;
	}
	
	
	@Column(name="MINACCE",length=256)
	@GraphQLQuery(name="minacce")
	public String getMinacce() {
		return minacce;
	}

	public void setMinacce(String minacce) {
		this.minacce = minacce;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_CREAZIONE")
	@GraphQLQuery(name="utenteCreazione")
	public Utente getUtenteCreazione() {
		return utenteCreazione;
	}

	public void setUtenteCreazione(Utente utenteCreazione) {
		this.utenteCreazione = utenteCreazione;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_MODIFICA")
	@GraphQLQuery(name="utenteModifica")
	public Utente getUtenteModifica() {
		return utenteModifica;
	}

	public void setUtenteModifica(Utente utenteModifica) {
		this.utenteModifica = utenteModifica;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_CREAZIONE")
	@GraphQLQuery(name="dataCreazione")
	public Date getDataCreazione() {
		return dataCreazione;
	}

	public void setDataCreazione(Date dataCreazione) {
		this.dataCreazione = dataCreazione;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_MODIFICA")
	@GraphQLQuery(name="dataModifica")
	public Date getDataModifica() {
		return dataModifica;
	}

	public void setDataModifica(Date dataModifica) {
		this.dataModifica = dataModifica;
	}

	@OneToMany(mappedBy="monitoraggioSpecie",cascade = {CascadeType.REMOVE},orphanRemoval=true)
	@GraphQLQuery(name="segnalazioni")
	public List<Segnalazione> getSegnalaziones() {
		return segnalaziones;
	}

	public void setSegnalaziones(List<Segnalazione> segnalaziones) {
		this.segnalaziones = segnalaziones;
		if (segnalaziones!=null && segnalaziones.getClass().equals(ArrayList.class)) {
			for (Segnalazione s : segnalaziones)
				s.setMonitoraggioSpecie(this);
			
		} 
		if (this.segnalaziones==null) this.segnalaziones = new ArrayList<Segnalazione>();

	}

	@OneToMany(mappedBy="monitoraggioSpecie",cascade = {CascadeType.REMOVE},orphanRemoval=true)
	@GraphQLQuery(name="segnalazioniAltreSpecie")
	public List<SegnalazioneAltreSpecie> getSegnalazioneAltreSpecies() {
		return segnalazioneAltreSpecies;
	}

	public void setSegnalazioneAltreSpecies(List<SegnalazioneAltreSpecie> segnalazioneAltreSpecies) {
		this.segnalazioneAltreSpecies = segnalazioneAltreSpecies;
		if (segnalazioneAltreSpecies!=null && segnalazioneAltreSpecies.getClass().equals(ArrayList.class)) {
			for (SegnalazioneAltreSpecie s : segnalazioneAltreSpecies)
				s.setMonitoraggioSpecie(this);
			
		}
		if (this.segnalazioneAltreSpecies==null) this.segnalazioneAltreSpecies = new ArrayList<SegnalazioneAltreSpecie>();

	}
	

	@GraphQLQuery(name="documenti")
	@OneToMany(cascade=CascadeType.REMOVE,orphanRemoval=true)
	@JoinTable(name="EREMITA_MONIT_SPECIE_DOC",
		joinColumns=@JoinColumn(name="MONITORAGGIO_SPECIE",referencedColumnName="ID"),
		inverseJoinColumns=@JoinColumn(name="DOCUMENTO",referencedColumnName="ID"))
	public List<Documento> getDocumenti() {
		return documenti;
	}

	public void setDocumenti(List<Documento> documenti) {
		this.documenti = documenti;
		if (documenti!=null && documenti.getClass().equals(ArrayList.class)) {
			for (Documento s : documenti) {
				s.setEntita("eremita_monitoraggio_specie");
				s.setIdEntita(this.getId());
			}
			
		}
		if (this.documenti==null) this.documenti = new ArrayList<Documento>();

	}

	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof MonitoraggioSpecie)) return false;
		
		MonitoraggioSpecie ms = (MonitoraggioSpecie)o;
		return (ms.getId()==this.getId());

	}
	
	@Override
	public String toString() {
		return "MonitoraggioSpecie-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (int)( getId()%Integer.MAX_VALUE);
	}
	
}
